<?php
include 'config.php';
date_default_timezone_set("Asia/Dhaka");

// --- TOKEN CHECK PART ---
if (isset($_GET['token'])) {
    $token = $_GET['token'];

    $stmt = $conn->prepare("SELECT id FROM users WHERE reset_token=?");
    $stmt->bind_param("s", $token);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 1) {
        // Show password reset form
        ?>
        <!DOCTYPE html>
        <html>
        <head>
            <title>Reset Password</title>
            <style>
                body {
                    font-family: Arial;
                    background: #f2f2f2;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    height: 100vh;
                }
                .box {
                    background: white;
                    padding: 20px;
                    border-radius: 8px;
                    box-shadow: 0 0 10px rgba(0,0,0,0.1);
                    width: 300px;
                    text-align: center;
                }
                input {
                    width: 100%;
                    padding: 10px;
                    margin: 8px 0;
                    border-radius: 5px;
                    border: 1px solid #ccc;
                }
                button {
                    padding: 10px;
                    width: 100%;
                    background: #007bff;
                    color: white;
                    border: none;
                    border-radius: 5px;
                }
            </style>
        </head>
        <body>
            <div class="box">
                <h3>Reset Your Password</h3>
                <form method="POST">
                    <input type="hidden" name="token" value="<?php echo htmlspecialchars($token); ?>">
                    <input type="password" name="new_password" placeholder="New Password" required>
                    <button type="submit">Reset Password</button>
                </form>
            </div>
        </body>
        </html>
        <?php
        exit;
    } else {
        echo "Invalid reset link.";
        exit;
    }
}


// --- PASSWORD UPDATE PART ---
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $token = $_POST['token'];
    $new_password = $_POST['new_password'];

    // Hash password
    $hashed = password_hash($new_password, PASSWORD_DEFAULT);

    $update = $conn->prepare("UPDATE users SET password=?, reset_token=NULL, reset_expires=NULL WHERE reset_token=?");
    $update->bind_param("ss", $hashed, $token);
    $update->execute();

    echo "Password has been successfully reset!";
}
?>