<?php
include 'config.php';
date_default_timezone_set("Asia/Dhaka"); // Optional

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'];

    // Check email exists
    $stmt = $conn->prepare("SELECT id FROM users WHERE email = ?");
    $stmt->bind_param("s", $email);
    $stmt->execute();
    $stmt->store_result();

    if ($stmt->num_rows === 1) {

        // Generate token
        $token = bin2hex(random_bytes(32));

        // Save only reset_token (no expire time)
        $save = $conn->prepare("UPDATE users SET reset_token=? WHERE email=?");
        $save->bind_param("ss", $token, $email);
        $save->execute();

        // Reset link (change to your actual domain or subdomain)
        $reset_link = "https://kbd.devxmehedi.top/CrazyTour/reset.php?token=$token";

        // Email send
        $subject = "Password Reset Link";
        $message = "Click here to reset your password:\n\n$reset_link";
        $headers = "From: mehedi@devxmehedi.top";

        mail($email, $subject, $message, $headers);

        echo "We have sent a reset link to your email.";
    } else {
        echo "Email not found.";
    }
}
?>